/****** Object:  StoredProcedure [dbo].[sp_ResetRespondent]    Script Date: 11/22/2009 14:00:42 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_resetrespondent]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[Sp_resetrespondent]
GO


CREATE PROCEDURE [dbo].[Sp_resetrespondent]
                @projectId  INT,
                @Respondent VARCHAR(10),
                @UserId     INT
AS
BEGIN	
	DELETE FROM response
	WHERE       rpsquestion NOT IN (SELECT ifquestion
									FROM   importedfields)
				AND rpsrespondent = @Respondent
  
	DELETE FROM note
	WHERE       notrespondent = @Respondent
  
	DELETE timeslothit
	WHERE  tshrespondent = @Respondent
  
	DECLARE  @callNumber INT
  
	SELECT @callNumber = Coalesce(Max(hiscallnumber),0) + 1
	FROM   historic
	WHERE  hisrespondent = @Respondent
  
	INSERT INTO historic
				(hisrespondent,
				hiscallnumber,
				hisinterviewer,
				hisresult,
				hiscalldate,
				hiscallduration,
				hiswait,
				hispause,
				projectid,
				collectmode)
	VALUES     (@Respondent,
				@callNumber,
				@UserId,
				'RS',
				Getutcdate(),
				0,
				0,
				0,
				@projectId,
				0)
  
	DECLARE  @iscompleted BIT
  
	SELECT @iscompleted = rescompleted
	FROM   respondent
	WHERE  resrespondent = @Respondent
  
	UPDATE respondent
	SET    rescoderesult = 'RS',
			rescompleted = 0,
			rescall = 0,
			reslastcompquest = 0,
			rescallcount = @callNumber,
			restimeslot = 0,
			resintervcall = CASE
							WHEN Substring(resintervcall,1,1) = 'G'
							THEN resintervcall
							ELSE ''
							END,
			projectid = @projectId,
			modifiedby = @userId,
			modified = Getutcdate(),
			ResCompletedDate = null
	WHERE  resrespondent = @Respondent
  
	IF @iscompleted = 1
	BEGIN
		EXEC sp_RespondentIncDecQuota
		@projectId ,
		@userId ,
		@Respondent ,
		0
	END
  
	EXEC Sp_recomputestratumandquotasrespondent
	@projectId ,
	@userId ,
	@Respondent

END
GO

